/*
 * Decompiled with CFR 0.152.
 */
package notryken.effecttimerplus.gui.component.listwidget;

import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_350;
import net.minecraft.class_7919;
import notryken.effecttimerplus.EffectTimerPlus;
import notryken.effecttimerplus.gui.component.listwidget.AbstractListWidget;
import notryken.effecttimerplus.gui.screen.ConfigScreen;
import notryken.effecttimerplus.util.MiscUtil;

public class PotencyListWidget
extends AbstractListWidget {
    protected AbstractListWidget.Entry header;
    protected AbstractListWidget.Entry toggleButton;
    protected AbstractListWidget.Entry cornerButton;
    protected AbstractListWidget.Entry colorSelectionSet;
    protected AbstractListWidget.Entry alphaSlider;
    protected AbstractListWidget.Entry redSlider;
    protected AbstractListWidget.Entry greenSlider;
    protected AbstractListWidget.Entry blueSlider;
    protected AbstractListWidget.Entry backAlphaSlider;
    protected AbstractListWidget.Entry resetButton;

    public PotencyListWidget(class_310 minecraft, int width, int height, int top, int bottom, int itemHeight, ConfigScreen parent) {
        super(minecraft, width, height, top, bottom, itemHeight, parent);
        int unitWidth = 200;
        int unitHeight = 18;
        int unitX = width - unitWidth - 10;
        Supplier<Integer> colorSource = EffectTimerPlus.config()::getPotencyColor;
        Consumer<Integer> colorDest = EffectTimerPlus.config()::setPotencyColor;
        this.header = new AbstractListWidget.Entry.TextEntry(this, unitX, 0, unitWidth, unitHeight, (class_2561)class_2561.method_43470((String)"Potency Text Options"), new class_7919[0]);
        this.toggleButton = new AbstractListWidget.Entry.OnOffButtonEntry(this, unitX, 0, unitWidth, unitHeight, (class_2561)class_2561.method_43470((String)"Display"), EffectTimerPlus.config().potencyEnabled, value -> {
            EffectTimerPlus.config().potencyEnabled = value;
        });
        this.cornerButton = new AbstractListWidget.Entry.IntCycleButtonEntry(this, unitX, 0, unitWidth, unitHeight, (class_2561)class_2561.method_43470((String)"Location"), EffectTimerPlus.config().getPotencyLocation(), value -> switch (value) {
            case 0 -> class_2561.method_43470((String)"Top Left");
            case 1 -> class_2561.method_43470((String)"Top Center");
            case 2 -> class_2561.method_43470((String)"Top Right");
            case 3 -> class_2561.method_43470((String)"Center Right");
            case 4 -> class_2561.method_43470((String)"Bottom Right");
            case 5 -> class_2561.method_43470((String)"Bottom Center");
            case 6 -> class_2561.method_43470((String)"Bottom Left");
            case 7 -> class_2561.method_43470((String)"Center Left");
            default -> throw new IllegalStateException("Unexpected positional index outside of allowed range (0-7): " + value);
        }, new Integer[]{0, 1, 2, 3, 4, 5, 6, 7}, value -> EffectTimerPlus.config().setPotencyLocation((int)value));
        this.colorSelectionSet = new AbstractListWidget.Entry.ColorSelectionSet(this, unitX, 0, unitWidth, color -> colorDest.accept(MiscUtil.withAlpha.applyAsInt((int)color, MiscUtil.fromAlpha.applyAsInt(MiscUtil.toAlpha.applyAsInt((Integer)colorSource.get())))));
        this.alphaSlider = new AbstractListWidget.Entry.ArgbSliderEntry2(this, unitX, unitWidth, unitHeight, "Opacity: ", colorSource, color -> colorDest.accept(MiscUtil.withAlpha.applyAsInt((Integer)colorSource.get(), (int)color)), MiscUtil.toAlpha, MiscUtil.fromAlpha);
        this.redSlider = new AbstractListWidget.Entry.ArgbSliderEntry2(this, unitX, unitWidth, unitHeight, "Red: ", colorSource, color -> colorDest.accept(MiscUtil.withRed.applyAsInt((Integer)colorSource.get(), (int)color)), MiscUtil.toRed, MiscUtil.fromRed);
        this.greenSlider = new AbstractListWidget.Entry.ArgbSliderEntry2(this, unitX, unitWidth, unitHeight, "Green: ", colorSource, color -> colorDest.accept(MiscUtil.withGreen.applyAsInt((Integer)colorSource.get(), (int)color)), MiscUtil.toGreen, MiscUtil.fromGreen);
        this.blueSlider = new AbstractListWidget.Entry.ArgbSliderEntry2(this, unitX, unitWidth, unitHeight, "Blue: ", colorSource, color -> colorDest.accept(MiscUtil.withBlue.applyAsInt((Integer)colorSource.get(), (int)color)), MiscUtil.toBlue, MiscUtil.fromBlue);
        Supplier<Integer> backColorSource = EffectTimerPlus.config()::getPotencyBackColor;
        Consumer<Integer> backColorDest = EffectTimerPlus.config()::setPotencyBackColor;
        this.backAlphaSlider = new AbstractListWidget.Entry.ArgbSliderEntry2(this, unitX, unitWidth, unitHeight, "Background Opacity: ", backColorSource, color -> backColorDest.accept(MiscUtil.withAlpha.applyAsInt((Integer)backColorSource.get(), (int)color)), MiscUtil.toAlpha, MiscUtil.fromAlpha);
        this.resetButton = new AbstractListWidget.Entry.ActionButtonEntry(this, unitX, 0, unitWidth, unitHeight, (class_2561)class_2561.method_43470((String)"Reset"), button -> {
            EffectTimerPlus.config().resetPotencyConfig();
            this.reload();
        });
        this.method_25321((class_350.class_351)this.header);
        this.method_25321((class_350.class_351)this.toggleButton);
        this.method_25321((class_350.class_351)this.cornerButton);
        this.method_25321((class_350.class_351)this.colorSelectionSet);
        this.method_25321((class_350.class_351)this.alphaSlider);
        this.method_25321((class_350.class_351)this.redSlider);
        this.method_25321((class_350.class_351)this.greenSlider);
        this.method_25321((class_350.class_351)this.blueSlider);
        this.method_25321((class_350.class_351)this.backAlphaSlider);
        this.method_25321((class_350.class_351)this.resetButton);
    }

    protected int method_25329() {
        return this.field_22742 - 6;
    }
}

